function GiveDefaultItems(userid)
	RoleplayData.GiveDefaultItems(userid)
end

function RoleplayData.eventPlayerDisconnect(name, userid, adress, steamid, reason)
	if RoleplayData.HungerMod then
		if string.find(string.lower(RoleplayData[userid].Job), "chef") or string.find(string.lower(RoleplayData[userid].Job), "cook") then
		RoleplayData.NrChefs = RoleplayData.NrChefs -1
		RoleplayData[userid].isChef = false
		end
	end
	
	-- Phew.. thats much to reset xD
	RoleplayData[userid].Cash = 100
	RoleplayData[userid].Age = "18"
	RoleplayData[userid].Job = "Arbeitslos"
	RoleplayData[userid].Gender = "Mann"
	RoleplayData[userid].Model = "02"
	RoleplayData[userid].ModelName = nil
	if RoleplayData.HungerMod then
	RoleplayData[userid].Hunger = RoleplayData.StartingHunger
	end
	RoleplayData[userid].Team = TEAM_GREEN
	RoleplayData[userid].Arrested = false
	RoleplayData[userid].NoWeapons = false
	RoleplayData[userid].Property = {}
	RoleplayData[userid].IsNoclip = false
	RoleplayData[userid].Position = 0
	RoleplayData[userid].Angle = 0
	RoleplayData[userid].IsSleeping = false
	RoleplayData[userid].RagdollID = 0
	RoleplayData[userid].SleepTimer = nil
	RoleplayData[userid].ChangeJob = true
	RoleplayData[userid].CanSleep = true
	RoleplayData[userid].Tranquilized = false
	RoleplayData[userid].Speed = 190
	RoleplayData[userid].CustomPay = false
	RoleplayData[userid].CustomPayMin = 0
	RoleplayData[userid].CustomPayMax = 0
	RoleplayData[userid].BleedTimer = nil
	RoleplayData[userid].inventory = {}
	RoleplayData[userid].inventory.enable = true
	RoleplayData[userid].inventory.open = 0
	RoleplayData[userid].inventory.weight = 0
	RoleplayData[userid].inventory.curx = nil -- Niled values for reference
	RoleplayData[userid].inventory.cury = nil
	RoleplayData[userid].inventory.acty = nil
	RoleplayData[userid].inventory.movx = nil
	RoleplayData[userid].inventory.movy = nil
	RoleplayData[userid].inventory.screen = nil
	RoleplayData[userid].inventory.posx = nil
	RoleplayData[userid].inventory.posy = nil
	RoleplayData[userid].inventory.aspectratio = 5/4 -- Common LCD Size.
	RoleplayData[userid].inventory.store = {}   	-- This is the only table you need to carryover to save all data.
									-- Call both reparseSTRAYobj and recountweight after restoring saved data.
	for x = 1, RoleplayData.Inventory.sizex do
        RoleplayData[userid].inventory.store[x] = {}
		for y = 1, RoleplayData.Inventory.sizey do
		RoleplayData[userid].inventory.store[x][y] = {}
		end
	end
end
HookEvent("eventPlayerDisconnect", RoleplayData.eventPlayerDisconnect)

function RoleplayData.PlayerSpawnChooseModel(playerid)
	RoleplayData.SetModels(playerid)
end
HookEvent("PlayerSpawnChooseModel", RoleplayData.PlayerSpawnChooseModel)
	
function RoleplayData.eventPlayerInitialSpawn(userid)
	if (userid == 1) then
	_TeamSetName(TEAM_BLUE, RoleplayData.BlueTeamName)
	_TeamSetName(TEAM_GREEN, RoleplayData.GreenTeamName)
	end
	
	RoleplayData.ShowGUI(userid)
	RoleplayData.UpdateDay()
	RoleplayData.SetAspectRatio(userid)
	if RoleplayData.HungerMod then
	RoleplayData[userid].Hunger = RoleplayData.StartingHunger
	end
end
HookEvent("eventPlayerInitialSpawn", RoleplayData.eventPlayerInitialSpawn)

function RoleplayData.eventPlayerKilled(userid, attacker, weapon)
	if RoleplayData.HungerMod then
	RoleplayData.RestoreHunger(userid)
	end
	RoleplayData.RespawnArrested(userid, true)
	
	local Loss = RoleplayData.CashLoss / 100
	local Sub = math.round(Loss * RoleplayData[userid].Cash, 0.01)
	RoleplayData[userid].Cash = RoleplayData[userid].Cash - Sub
	RoleplayData[userid].Cash = math.round(RoleplayData[userid].Cash, 0.01)
	RoleplayData.ShowGUI(userid)
	
	if RoleplayData.Mugging and RoleplayData.CashLoss > 0 then
	local Money = _EntCreate("prop_physics")
	_EntPrecacheModel("models/props_junk/garbage_bag001a.mdl")
	_EntSetModel(Money, "models/props_junk/garbage_bag001a.mdl")
	_EntSetPos(Money, _EntGetPos(userid))
	_EntSpawn(Money)
	
	local MoneyInfo = {}
	MoneyInfo.MoneyID = Money
	MoneyInfo.Amount = Sub
	table.insert(RoleplayData.Money, MoneyInfo)
	end
end
HookEvent("eventPlayerKilled", RoleplayData.eventPlayerKilled)

function RoleplayData.eventPlayerSpawn(userid)
	RoleplayData.SetTeam(userid)
	RoleplayData.RespawnArrested(userid, false)
	AddTimer(0.05, 1, RoleplayData.CheckSleep, userid)
end
HookEvent("eventPlayerSpawn", RoleplayData.eventPlayerSpawn)

function RoleplayData.eventPlayerUseEntity(userid, entity)
	local Pos1 = _PlayerGetShootPos(userid)
	local Pos2 = _EntGetPos(entity)
	local Length = vecLength(vecSub(Pos1, Pos2))
	
	if Length <= RoleplayData.BuyRange then
	RoleplayData.OnChefUse(userid, entity)
	end	
	
	if Length <= RoleplayData.UseRange then
		if RoleplayData.HungerMod then
		RoleplayData.EatFood(userid, entity)
		end
	RoleplayData.UseLetter(userid, entity)
	RoleplayData.TakeMoneyBag(userid, entity)
	end
end
HookEvent("eventPlayerUseEntity", RoleplayData.eventPlayerUseEntity)

function eventPlayerSay(userid, strText, bTeam)
	local Block = RoleplayData.SetJob(userid, strText)
	if Block then
	return false
	end
	
	local Block = RoleplayData.OutOfCharacter(userid, strText)
	if Block then
	return false
	end
	
	local Block = RoleplayData.MeText(userid, strText)
	if Block then
	return false
	end
	
	local Block = RoleplayData.GiveMoney(userid, strText)
	if Block then
	return false
	end
	
	local Block = RoleplayData.PrivateMessage(userid, strText)
	if Block then
	return false
	end
	
	local Block = RoleplayData.ChangeModel(userid, strText)
	if Block then
	return false
	end
	
	local Block = RoleplayData.Whisper(userid, strText)
	if Block then
	return false
	end
	
	local Block = RoleplayData.VoteCop(userid, strText)
	if Block then
	return false
	end
	
	local Block = RoleplayData.VoteKickCop(userid, strText)
	if Block then
	return false
	end
	
	local Block = RoleplayData.HelpText(userid, strText)
	if Block then
	return false
	end
	
	local Block = RoleplayData.SetAge(userid, strText)
	if Block then
	return false
	end
	
	local Block = RoleplayData.BecomeCitizen(userid, strText)
	if Block then
	return false
	end
	
	local Block = RoleplayData.Sleep(userid, strText)
	if Block then
	return false
	end
	
	local Block = RoleplayData.CreateLetter(userid, strText)
	if Block then
	return false
	end

	local Block = RoleplayData.MakeUserCitizen(userid, strText)
	if Block then
	return false
	end
	
	if RoleplayData.HungerMod then
		local Block = RoleplayData.SpawnFood(userid, strText)
		if Block then
		return false
		end
	end
	
return strText
end

function onPlayerRemove(userid, entity)
	local Rem = RoleplayData.LetterRemove(userid, entity)
	if not Rem then
	return false
	end
	
	local Rem = RoleplayData.OnRemove(userid, entity)
	if not Rem then
	return false
	end
	
	if (_EntGetName(entity) == "npc_chef") and not RoleplayData.isAdmin(userid) then
	return false
	end

return true
end

function onShowHelp(userid)
	RoleplayData.ShowMainHelp(userid)
end

function onShowTeam(userid)
	RoleplayData.ShowAdminMenu(userid)
end

function onShowSpare1(userid)
	RoleplayData.OwnDoor(userid)
end

function onShowSpare2(userid)
	RoleplayData.ShowUserInfo(userid)
	RoleplayData.ShowMoneyInfo(userid)
	RoleplayData.ShowInventory(userid)
end 